implementation module windowdevice


//	Clean Object I/O library, version 1.1


import	StdBool, StdEnum, StdList, StdMisc, StdTuple
import	oswindow
import	commondef, controldefaccess, controllayout, controlpos, controlresize, receiverid, scheduler, 
		windowaccess, windowclipstate, windowdefaccess, windowdispose, windowevent, windowupdate
from	menuevent import MenuSystemStateGetMenuHandles

windowdeviceFatalError :: String String -> .x
windowdeviceFatalError function error
	= FatalError function "windowdevice" error


WindowFunctions :: DeviceFunctions i o .l .p
WindowFunctions
	= {	dShow	= id //windowShow not yet implemented
	  ,	dHide	= id //windowHide not yet implemented
	  ,	dEvent	= windowEvent
	  ,	dDoIO	= windowIO
	  ,	dOpen	= windowOpen
	  ,	dClose	= windowClose
	  }


/*	windowOpen initialises the window device for this interactive process.
*/
windowOpen :: !(IOSt .l .p) -> IOSt .l .p
windowOpen ioState
	# (ioInterface,ioState)	= IOStGetDocumentInterface ioState
	  windows				= {	whsWindows		= []
/*							  ,	whsCursorInfo	= {	cInfoChanged	= True
												  ,	cLocalRgn		= rgnH
												  ,	cMouseWasInRgn	= False
												  ,	cLocalShape		= StandardCursor
												  ,	cGlobalSet		= False
												  ,	cGlobalShape	= StandardCursor
												  }
*/							  ,	whsIds			= [1..]
							  ,	whsNrWindowBound= case ioInterface of
							  						NDI	-> Finite 0
							  						SDI	-> Finite 1
							  						MDI	-> Infinite
							  ,	whsModal		= False
							  }
	= IOStSetDevice (WindowSystemState windows) ioState


/*	windowClose closes all windows associated with this interactive process. 
	Bindings of (Receiver/Timer)s are undone.
	System resources are released.
*/
windowClose :: (IOSt .l .p) -> IOSt .l .p
windowClose ioState
	# (wDevice,ioState)	= IOStGetDevice WindowDevice ioState
	  windows			= WindowSystemStateGetWindowHandles wDevice
	# (ridss,ioState)	= accIOToolbox (StateMap disposeWindowStateHandle windows.whsWindows) ioState
	# ioState			= unbindRIds (flatten ridss) ioState
	# ioState			= IOStRemoveDevice WindowDevice ioState
	= ioState


/*	windowIO handles the DeviceEvents that have been filtered by windowEvent.
*/
windowIO :: OSSleepTime !(DeviceEvent i o) !(PSt .l .p) -> (OSSleepTime,!DeviceEvent i o,!PSt .l .p)

windowIO sleepTime receiverEvent=:(ReceiverEvent msgEvent) pState
	# (wDevice,ioState)			= IOStGetDevice WindowDevice pState.io
	  windows					= WindowSystemStateGetWindowHandles wDevice
	  (found,wsH,windows)		= getWindowHandlesWindow (toWID wId) windows
	| not found
	= windowdeviceFatalError "windowIO _ (ReceiverEvent _) _" "window could not be found"
	= (sleepTime,ReceiverEvent msgEvent1,pState2)
	with
		windows1				= setWindowHandlesWindow wsH1 windows
		ioState1				= IOStSetDevice (WindowSystemState windows1) ioState
		pState1					= {pState & io=ioState1}
		(msgEvent1,wsH1,pState2)= windowStateMsgIO msgEvent wsH pState1
where
	recLoc						= getMsgEventRecLoc msgEvent
	wId							= recLoc.rlParentId

windowIO sleepTime deviceEvent=:(CompoundScrollAction info) pState
	# (wDevice,ioState)		= IOStGetDevice WindowDevice pState.io
	  windows				= WindowSystemStateGetWindowHandles wDevice
	  (found,wsH,windows)	= getWindowHandlesWindow (toWID info.csaWIDS.wId) windows
	| not found
	= windowdeviceFatalError "windowIO _ (CompoundScrollAction _) _" "window could not be found"
	# (wsH,ioState)			= accIOToolbox (windowStateCompoundScrollActionIO info wsH) ioState
	  windows				= setWindowHandlesWindow wsH windows
	# ioState				= IOStSetDevice (WindowSystemState windows) ioState
	# pState				= {pState & io=ioState}
	= (sleepTime,deviceEvent,pState)

windowIO sleepTime deviceEvent=:(ControlKeyboardAction info) pState
	# (wDevice,ioState)		= IOStGetDevice WindowDevice pState.io
	  windows				= WindowSystemStateGetWindowHandles wDevice
	  (found,wsH,windows)	= getWindowHandlesWindow (toWID info.ckWIDS.wId) windows
	| not found
	= windowdeviceFatalError "windowIO _ (ControlKeyboardAction _) _" "window could not be found"
	= (sleepTime,deviceEvent,pState2)
	with
		windows1			= setWindowHandlesWindow wsH1 windows
		ioState1			= IOStSetDevice (WindowSystemState windows1) ioState
		pState1				= {pState & io=ioState1}
		(wsH1,pState2)		= windowStateControlKeyboardActionIO info wsH pState1

windowIO sleepTime deviceEvent=:(ControlMouseAction info) pState
	# (wDevice,ioState)		= IOStGetDevice WindowDevice pState.io
	  windows				= WindowSystemStateGetWindowHandles wDevice
	  (found,wsH,windows)	= getWindowHandlesWindow (toWID info.cmWIDS.wId) windows
	| not found
	= windowdeviceFatalError "windowIO _ (ControlMouseAction _) _" "window could not be found"
	= (sleepTime,deviceEvent,pState2)
	with
		windows1			= setWindowHandlesWindow wsH1 windows
		ioState1			= IOStSetDevice (WindowSystemState windows1) ioState
		pState1				= {pState & io=ioState1}
		(wsH1,pState2)		= windowStateControlMouseActionIO info wsH pState1

windowIO sleepTime deviceEvent=:(ControlSelection info) pState
	# (wDevice,ioState)		= IOStGetDevice WindowDevice pState.io
	  windows				= WindowSystemStateGetWindowHandles wDevice
	  (found,wsH,windows)	= getWindowHandlesWindow (toWID info.csWIDS.wId) windows
	| not found
	= windowdeviceFatalError "windowIO _ (ControlSelection _) _" "window could not be found"
	= (sleepTime,deviceEvent,pState2)
	with
		windows1			= setWindowHandlesWindow wsH1 windows
		ioState1			= IOStSetDevice (WindowSystemState windows1) ioState
		pState1				= {pState & io=ioState1}
		(wsH1,pState2)		= windowStateControlSelectionIO info wsH pState1

windowIO sleepTime deviceEvent=:(ControlSliderAction info) pState
	# (wDevice,ioState)		= IOStGetDevice WindowDevice pState.io
	  windows				= WindowSystemStateGetWindowHandles wDevice
	  (found,wsH,windows)	= getWindowHandlesWindow (toWID info.cslWIDS.wId) windows
	| not found
	= windowdeviceFatalError "windowIO _ (ControlSliderAction _) _" "window could not be found"
	= (sleepTime,deviceEvent,pState2)
	with
		windows1			= setWindowHandlesWindow wsH1 windows
		ioState1			= IOStSetDevice (WindowSystemState windows1) ioState
		pState1				= {pState & io=ioState1}
		(wsH1,pState2)		= windowStateControlSliderActionIO info wsH pState1

windowIO sleepTime deviceEvent=:(WindowActivation wids) pState
	# (wDevice,ioState)		= IOStGetDevice WindowDevice pState.io
	  windows				= WindowSystemStateGetWindowHandles wDevice
	  wid					= toWID wids.wId
	  (found,wsH,windows)	= getWindowHandlesWindow wid windows
	| not found
	= windowdeviceFatalError "windowIO _ (WindowActivation _)" "window could not be found"
	= (sleepTime,deviceEvent,pState2)
	with
		(_,_,windows1)		= removeWindowHandlesWindow wid windows		// Remove the placeholder from windows
		windows2			= addWindowHandlesWindow 0 wsH1 windows1	// Place  the change window in front of all windows
		ioState1			= IOStSetDevice (WindowSystemState windows2) ioState
		pState1				= {pState & io=ioState1}
		(wsH1,pState2)		= windowStateActivationIO wsH pState1

windowIO sleepTime deviceEvent=:(WindowDeactivation wids) pState
	# (wDevice,ioState)		= IOStGetDevice WindowDevice pState.io
	  windows				= WindowSystemStateGetWindowHandles wDevice
	  (found,wsH,windows)	= getWindowHandlesWindow (toWID wids.wId) windows
	| not found
	= windowdeviceFatalError "windowIO _ (WindowDeactivation _)" "window could not be found"
	= (sleepTime,deviceEvent,pState2)
	with
		windows1			= setWindowHandlesWindow wsH1 windows
		ioState1			= IOStSetDevice (WindowSystemState windows1) ioState
		pState1				= {pState & io=ioState1}
		(wsH1,pState2)		= windowStateDeactivationIO wsH pState1

windowIO sleepTime deviceEvent=:(WindowKeyboardAction action) pState
	# (wDevice,ioState)		= IOStGetDevice WindowDevice pState.io
	  windows				= WindowSystemStateGetWindowHandles wDevice
	  (found,wsH,windows)	= getWindowHandlesWindow (toWID action.wkWIDS.wId) windows
	| not found
	= windowdeviceFatalError "windowIO _ (WindowKeyboardAction _)" "window could not be found"
	= (sleepTime,deviceEvent,pState2)
	with
		windows1			= setWindowHandlesWindow wsH1 windows
		ioState1			= IOStSetDevice (WindowSystemState windows1) ioState
		pState1				= {pState & io=ioState1}
		(wsH1,pState2)		= windowStateWindowKeyboardActionIO action wsH pState1

windowIO sleepTime deviceEvent=:(WindowMouseAction action) pState
	# (wDevice,ioState)		= IOStGetDevice WindowDevice pState.io
	  windows				= WindowSystemStateGetWindowHandles wDevice
	  (found,wsH,windows)	= getWindowHandlesWindow (toWID action.wmWIDS.wId) windows
	| not found
	= windowdeviceFatalError "windowIO _ (WindowMouseAction _)" "window could not be found"
	= (sleepTime,deviceEvent,pState2)
	with
		windows1			= setWindowHandlesWindow wsH1 windows
		ioState1			= IOStSetDevice (WindowSystemState windows1) ioState
		pState1				= {pState & io=ioState1}
		(wsH1,pState2)		= windowStateWindowMouseActionIO action wsH pState1

windowIO sleepTime deviceEvent=:(WindowRequestClose wids) pState
	# (wDevice,ioState)		= IOStGetDevice WindowDevice pState.io
	  windows				= WindowSystemStateGetWindowHandles wDevice
	  (found,wsH,windows)	= getWindowHandlesWindow (toWID wids.wId) windows
	| not found
	= windowdeviceFatalError "windowIO _ (WindowRequestClose _)" "window could not be found"
	= (sleepTime,deviceEvent,pState2)
	with
		windows1			= setWindowHandlesWindow wsH1 windows
		ioState1			= IOStSetDevice (WindowSystemState windows1) ioState
		pState1				= {pState & io=ioState1}
		(wsH1,pState2)		= windowStateRequestCloseIO wsH pState1

windowIO sleepTime deviceEvent=:(WindowScrollAction info) pState
	# (wDevice,ioState)		= IOStGetDevice WindowDevice pState.io
	  windows				= WindowSystemStateGetWindowHandles wDevice
	  (found,wsH,windows)	= getWindowHandlesWindow (toWID info.wsaWIDS.wId) windows
	| not found
	= windowdeviceFatalError "windowIO _ (WindowScrollAction _)" "window could not be found"
	# (wsH,ioState)			= accIOToolbox (windowStateScrollActionIO info wsH) ioState
	  windows				= setWindowHandlesWindow wsH windows
	# ioState				= IOStSetDevice (WindowSystemState windows) ioState
	# pState				= {pState & io=ioState}
	= (sleepTime,deviceEvent,pState)

windowIO sleepTime deviceEvent=:(WindowSizeAction info) pState
	# (wDevice,ioState)		= IOStGetDevice WindowDevice pState.io
	  windows				= WindowSystemStateGetWindowHandles wDevice
	  (found,wsH,windows)	= getWindowHandlesWindow (toWID info.wsWIDS.wId) windows
	| not found
	= windowdeviceFatalError "windowIO _ (WindowSizeAction _)" "window could not be found"
	# (wsH,ioState)			= accIOToolbox (windowStateSizeAction info wsH) ioState
	  windows				= setWindowHandlesWindow wsH windows
	# ioState				= IOStSetDevice (WindowSystemState windows) ioState
	# pState				= {pState & io=ioState}
	= (sleepTime,deviceEvent,pState)

windowIO sleepTime deviceEvent=:(WindowUpdate info) pState
	# (wDevice,ioState)		= IOStGetDevice WindowDevice pState.io
	  windows				= WindowSystemStateGetWindowHandles wDevice
	  (found,wsH,windows)	= getWindowHandlesWindow (toWID info.updWIDS.wId) windows
	| not found
	= windowdeviceFatalError "windowIO _ (WindowUpdate _)" "window could not be found"
	# (wsH,ioState)			= accIOToolbox (windowStateUpdateIO info wsH) ioState
	  windows				= setWindowHandlesWindow wsH windows
	# ioState				= IOStSetDevice (WindowSystemState windows) ioState
	# pState				= {pState & io=ioState}
	= (sleepTime,deviceEvent,pState)
where
	windowStateUpdateIO :: !UpdateInfo !(WindowStateHandle .ps) !*OSToolbox -> (!WindowStateHandle .ps,!*OSToolbox)
	windowStateUpdateIO info wsH=:{wshHandle=Just wlsH=:{wlsHandle=wH}} tb
		# (wH,tb)			= updatewindow info wH tb
		  wsH				= {wsH & wshHandle=Just {wlsH & wlsHandle=wH}}
		= (wsH,tb)
	windowStateUpdateIO _ _ _
		= windowdeviceFatalError "windowIO _ (WindowUpdate _) _" "unexpected placeholder argument"

windowIO _ _ _
	= windowdeviceFatalError "windowIO" "unexpected DeviceEvent"


/*	windowStateMsgIO handles all message events.
*/
windowStateMsgIO :: !(MsgEvent i o) !(WindowStateHandle (PSt .l .p)) (PSt .l .p) -> (!MsgEvent i o,!WindowStateHandle (PSt .l .p),PSt .l .p)
windowStateMsgIO msgEvent wsH=:{wshHandle=Just wlsH=:{wlsState=ls,wlsHandle=wH}} pState
	= (msgEvent1,{wsH & wshHandle=Just {wlsH & wlsState=ls1,wlsHandle=wH1}},pState1)
where
	recLoc							= getMsgEventRecLoc msgEvent
	rId								= recLoc.rlReceiverId
	action							= case msgEvent of
										(QASyncMessage msg)	-> windowControlQASyncIO rId msg
										( ASyncMessage msg) -> windowControlASyncIO  rId msg
										(  SyncMessage msg) -> windowControlSyncIO   rId msg
	(msgEvent1,wH1,(ls1,pState1))	= action wH (ls,pState)

	//	windowControlQASyncIO queues an asynchronous message in the message queue of the indicated receiver control.
	windowControlQASyncIO :: !Id !(QASyncMessage i) !(WindowHandle .ls .ps) (.ls,.ps) -> (!MsgEvent i o,!WindowHandle .ls .ps,(.ls,.ps))
	windowControlQASyncIO rId msg wH=:{whItems} ls_ps
		= (QASyncMessage msg,{wH & whItems=itemHs},ls_ps)
	where
		(_,itemHs)	= elementsControlQASyncIO rId msg.qasmMsg whItems
		
		elementsControlQASyncIO :: !Id m ![WElementHandle .ls .ps] -> (!Bool,![WElementHandle .ls .ps])
		elementsControlQASyncIO rId msg [itemH:itemHs]
			# (done,itemH)	= elementControlQASyncIO rId msg itemH
			| done
			= (done,[itemH:itemHs])
			# (done,itemHs)	= elementsControlQASyncIO rId msg itemHs
			= (done,[itemH:itemHs])
		where
			elementControlQASyncIO :: !Id m !(WElementHandle .ls .ps) -> (!Bool,!WElementHandle .ls .ps)
			elementControlQASyncIO rId msg (WListLSHandle itemHs)
				# (done,itemHs)			= elementsControlQASyncIO rId msg itemHs
				= (done,WListLSHandle itemHs)
			elementControlQASyncIO rId msg (WExtendLSHandle wExH=:{wExtendItems=itemHs})
				# (done,itemHs)	= elementsControlQASyncIO rId msg itemHs
				= (done,WExtendLSHandle {wExH & wExtendItems=itemHs})
			elementControlQASyncIO rId msg (WChangeLSHandle wChH=:{wChangeItems=itemHs})
				# (done,itemHs)		= elementsControlQASyncIO rId msg itemHs
				= (done,WChangeLSHandle {wChH & wChangeItems=itemHs})
			elementControlQASyncIO rId msg (WItemHandle itemH)
				| not (identifyMaybeId rId itemH.wItemId)
					| itemKind<>IsCompoundControl
					= (False,WItemHandle itemH)
					// otherwise
					# (done,itemHs)	= elementsControlQASyncIO rId msg itemH.wItems
					= (done,WItemHandle {itemH & wItems=itemHs})
				| itemKind<>IsOtherControl "Receiver" && itemKind<>IsOtherControl "Receiver2"
					= (True,WItemHandle itemH)
				// otherwise
				# rH	= getWItemReceiverInfo itemH.wItemInfo
				# rH	= receiverAddASyncMessage rId msg rH
				# itemH	= {itemH & wItemInfo=ReceiverInfo rH}
				= (True,WItemHandle itemH)
			where
				itemKind	= itemH.wItemKind
		elementsControlQASyncIO _ _ _
			= (False,[])

	//	windowControlASyncIO handles the first asynchronous message in the message queue of the indicated receiver control.
	windowControlASyncIO :: !Id !ASyncMessage !(WindowHandle .ls .ps) (.ls,.ps) -> (!MsgEvent i o,!WindowHandle .ls .ps,(.ls,.ps))
	windowControlASyncIO rId msg wH=:{whItems} ls_ps
		= (ASyncMessage msg,{wH & whItems=itemHs},ls_ps1)
	where
		(_,itemHs,ls_ps1)	= elementsControlASyncIO rId whItems ls_ps
		
		elementsControlASyncIO :: !Id ![WElementHandle .ls .ps] (.ls,.ps) -> (!Bool,![WElementHandle .ls .ps],(.ls,.ps))
		elementsControlASyncIO rId [itemH:itemHs] ls_ps
			# (done,itemH,ls_ps)	= elementControlASyncIO rId itemH ls_ps
			| done
			= (done,[itemH:itemHs],ls_ps)
			# (done,itemHs,ls_ps)	= elementsControlASyncIO rId itemHs ls_ps
			= (done,[itemH:itemHs],ls_ps)
		where
			elementControlASyncIO :: !Id !(WElementHandle .ls .ps) (.ls,.ps) -> (!Bool,!WElementHandle .ls .ps,(.ls,.ps))
			elementControlASyncIO rId (WListLSHandle itemHs) ls_ps
				# (done,itemHs,ls_ps)			= elementsControlASyncIO rId itemHs ls_ps
				= (done,WListLSHandle itemHs,ls_ps)
			elementControlASyncIO rId (WExtendLSHandle {wExtendLS=extLS,wExtendItems=itemHs}) (ls,ps)
				# (done,itemHs,((extLS,ls),ps))	= elementsControlASyncIO rId itemHs ((extLS,ls),ps)
				= (done,WExtendLSHandle {wExtendLS=extLS,wExtendItems=itemHs},(ls,ps))
			elementControlASyncIO rId (WChangeLSHandle {wChangeLS=chLS,wChangeItems=itemHs}) (ls,ps)
				# (done,itemHs,(chLS,ps))		= elementsControlASyncIO rId itemHs (chLS,ps)
				= (done,WChangeLSHandle {wChangeLS=chLS,wChangeItems=itemHs},(ls,ps))
			elementControlASyncIO rId (WItemHandle itemH) ls_ps
				| not (identifyMaybeId rId itemH.wItemId)
					| itemKind<>IsCompoundControl
					= (False,WItemHandle itemH,ls_ps)
					// otherwise
					# (done,itemHs,ls_ps)	= elementsControlASyncIO rId itemH.wItems ls_ps
					= (done,WItemHandle {itemH & wItems=itemHs},ls_ps)
				| itemKind<>IsOtherControl "Receiver" && itemKind<>IsOtherControl "Receiver2"
					= (True,WItemHandle itemH,ls_ps)
				// otherwise
				# rH			= getWItemReceiverInfo itemH.wItemInfo
				# (rH,ls_ps)	= receiverASyncIO rH ls_ps
				# itemH			= {itemH & wItemInfo=ReceiverInfo rH}
				= (True,WItemHandle itemH,ls_ps)
			where
				itemKind	= itemH.wItemKind
				
				receiverASyncIO :: !(ReceiverHandle .ls .ps) (.ls,.ps) -> (!ReceiverHandle .ls .ps,(.ls,.ps))
				receiverASyncIO rH=:{rASMQ=[msg:msgs],rFun} ls_ps
					# (ls,_,ps)	= rFun msg ls_ps
					= ({rH & rASMQ=msgs},(ls,ps))
				receiverASyncIO _ _
					= windowdeviceFatalError "receiverASyncIO" "unexpected empty asynchronous message queue"
		elementsControlASyncIO _ _ ls_ps
			= (False,[],ls_ps)

	//	windowControlSyncIO lets the indicated receiver control handle the synchronous message.
	windowControlSyncIO :: !Id !(SyncMessage i o) !(WindowHandle .ls .ps) (.ls,.ps) -> (!MsgEvent i o,WindowHandle .ls .ps,(.ls,.ps))
	windowControlSyncIO r2Id msg wH=:{whItems} ls_ps
		= (SyncMessage msg1,{wH & whItems=itemHs},ls_ps1)
	where
		(_,msg1,itemHs,ls_ps1)	= elementsControlSyncIO r2Id msg whItems ls_ps
		
		elementsControlSyncIO :: !Id !(SyncMessage i o) ![WElementHandle .ls .ps] (.ls,.ps) -> (!Bool,!SyncMessage i o,[WElementHandle .ls .ps],(.ls,.ps))
		elementsControlSyncIO r2Id msg [itemH:itemHs] ls_ps
			# (done,msg,itemH,ls_ps)	= elementControlSyncIO r2Id msg itemH ls_ps
			| done
			= (done,msg,[itemH:itemHs],ls_ps)
			# (done,msg,itemHs,ls_ps)	= elementsControlSyncIO r2Id msg itemHs ls_ps
			= (done,msg,[itemH:itemHs],ls_ps)
		where
			elementControlSyncIO :: !Id !(SyncMessage i o) !(WElementHandle .ls .ps) (.ls,.ps) -> (!Bool,!SyncMessage i o,WElementHandle .ls .ps,(.ls,.ps))
			elementControlSyncIO r2Id msg (WListLSHandle itemHs) ls_ps
				# (done,msg,itemHs,ls_ps)			= elementsControlSyncIO r2Id msg itemHs ls_ps
				= (done,msg,WListLSHandle itemHs,ls_ps)
			elementControlSyncIO r2Id msg (WExtendLSHandle {wExtendLS=extLS,wExtendItems=itemHs}) (ls,ps)
				# (done,msg,itemHs,((extLS,ls),ps))	= elementsControlSyncIO r2Id msg itemHs ((extLS,ls),ps)
				= (done,msg,WExtendLSHandle {wExtendLS=extLS,wExtendItems=itemHs},(ls,ps))
			elementControlSyncIO r2Id msg (WChangeLSHandle {wChangeLS=chLS,wChangeItems=itemHs}) (ls,ps)
				# (done,msg,itemHs,(chLS,ps))		= elementsControlSyncIO r2Id msg itemHs (chLS,ps)
				= (done,msg,WChangeLSHandle {wChangeLS=chLS,wChangeItems=itemHs},(ls,ps))
			elementControlSyncIO r2Id msg (WItemHandle itemH) ls_ps
				| not (identifyMaybeId r2Id itemH.wItemId)
					| itemKind<>IsCompoundControl
					= (False,msg,WItemHandle itemH,ls_ps)
					// otherwise
					# (done,msg,itemHs,ls_ps)	= elementsControlSyncIO r2Id msg itemH.wItems ls_ps
					= (done,msg,WItemHandle {itemH & wItems=itemHs},ls_ps)
				| itemKind<>IsOtherControl "Receiver" && itemKind<>IsOtherControl "Receiver2"
					= (True,msg,WItemHandle itemH,ls_ps)
				// otherwise
				# rH				= getWItemReceiverInfo itemH.wItemInfo
				# (msg,rH,ls_ps)	= receiverSyncIO msg rH ls_ps
				# itemH				= {itemH & wItemInfo=ReceiverInfo rH}
				= (True,msg,WItemHandle itemH,ls_ps)
			where
				itemKind	= itemH.wItemKind
				
				receiverSyncIO :: !(SyncMessage i o) !(ReceiverHandle .ls .ps) (.ls,.ps) -> (!SyncMessage i o,ReceiverHandle .ls .ps,(.ls,.ps))
				receiverSyncIO msg rH ls_ps
					# (response,rH,ls_ps)	= receiverHandleSyncMessage msg rH ls_ps
					= ({msg & smResp=response},rH,ls_ps)
		elementsControlSyncIO _ msg _ ls_ps
			= (False,msg,[],ls_ps)
windowStateMsgIO  _ _ _
	= windowdeviceFatalError "windowStateMsgIO" "unexpected window placeholder"


/*	windowStateCompoundScrollActionIO handles the mouse actions of CompoundControl scrollbars.
*/
windowStateCompoundScrollActionIO :: !CompoundScrollActionInfo !(WindowStateHandle .ps) !*OSToolbox
															-> (!WindowStateHandle .ps, !*OSToolbox)
windowStateCompoundScrollActionIO info wsH=:{wshHandle=Just wlsH=:{wlsHandle=wH}} tb
	# (wH,tb)	= windowControlCompoundScrollActionIO info wH tb
	= ({wsH & wshHandle=Just {wlsH & wlsHandle=wH}},tb)
where
	windowControlCompoundScrollActionIO :: !CompoundScrollActionInfo !(WindowHandle .ls .ps) !*OSToolbox
																  -> (!WindowHandle .ls .ps, !*OSToolbox)
	windowControlCompoundScrollActionIO info wH=:{whItems} tb
		# (_,itemHs,tb)	= elementsCompoundScrollActionIO info whItems tb
		= ({wH & whItems=itemHs},tb)
	where
		elementsCompoundScrollActionIO :: !CompoundScrollActionInfo ![WElementHandle .ls .ps] !*OSToolbox
														   -> (!Bool,[WElementHandle .ls .ps],!*OSToolbox)
		elementsCompoundScrollActionIO info [itemH:itemHs] tb
			# (done,itemH,tb)	= elementCompoundScrollActionIO info itemH tb
			| done
			= (done,[itemH:itemHs],tb)
			# (done,itemHs,tb)	= elementsCompoundScrollActionIO info itemHs tb
			= (done,[itemH:itemHs],tb)
		where
			elementCompoundScrollActionIO :: !CompoundScrollActionInfo !(WElementHandle .ls .ps) !*OSToolbox
															  -> (!Bool,!WElementHandle .ls .ps, !*OSToolbox)
			elementCompoundScrollActionIO info (WListLSHandle itemHs) tb
				# (done,itemHs,tb)			= elementsCompoundScrollActionIO info itemHs tb
				= (done,WListLSHandle itemHs,tb)
			elementCompoundScrollActionIO info (WExtendLSHandle wExH=:{wExtendItems=itemHs}) tb
				# (done,itemHs,tb)	= elementsCompoundScrollActionIO info itemHs tb
				= (done,WExtendLSHandle {wExH & wExtendItems=itemHs},tb)
			elementCompoundScrollActionIO info (WChangeLSHandle wChH=:{wChangeItems=itemHs}) tb
				# (done,itemHs,tb)		= elementsCompoundScrollActionIO info itemHs tb
				= (done,WChangeLSHandle {wChH & wChangeItems=itemHs},tb)
			elementCompoundScrollActionIO info (WItemHandle itemH) tb
				| info.csaItemNr<>itemH.wItemNr
					| itemH.wItemKind<>IsCompoundControl
					= (False,WItemHandle itemH,tb)
					# (done,itemHs,tb)	= elementsCompoundScrollActionIO info itemH.wItems tb
					  itemH				= {itemH & wItems=itemHs}
					= (done, WItemHandle itemH,tb)
				# (itemH,tb)	= itemCompoundScrollActionIO info itemH tb
				= (True,WItemHandle itemH,tb)
			where
				itemCompoundScrollActionIO :: !CompoundScrollActionInfo !(WItemHandle .ls .ps) !*OSToolbox
																	 -> (!WItemHandle .ls .ps, !*OSToolbox)
				itemCompoundScrollActionIO info itemH=:{wItemKind,wItems} tb
					| wItemKind<>IsCompoundControl		// This alternative should never occur
					= windowdeviceFatalError "windowStateCompoundScrollActionIO" "CompoundScrollAction does not correspond with CompoundControl"
					| newThumb==oldThumb
					= (itemH,tb)
					# tb				= OSsetCompoundSliderThumb info.csaItemPtr isHorizontal newOSThumb True tb
					# (itemHs,tb)		= movecontrolspos (toVector (origin-newOrigin)) info.csaWIDS.wPtr itemH.wItemPos wItems tb
					# tb				= OSinvalidateWindow info.csaItemPtr tb
					  itemH				= {	itemH & wItemInfo	= CompoundInfo {compoundInfo & compoundOrigin=newOrigin}
						  						  , wItems		= itemHs
						  				  }
					  itemH				= invalidateCompoundClipState itemH
					= (itemH,tb)
				where
					compoundSize		= itemH.wItemSize
					compoundInfo		= getWItemCompoundInfo itemH.wItemInfo
					origin				= compoundInfo.compoundOrigin
					domain				= compoundInfo.compoundDomain
					isHorizontal		= info.csaDirection==Horizontal
					scrollInfo			= fromJust (if isHorizontal compoundInfo.compoundHScroll compoundInfo.compoundVScroll)
					scrollFun			= scrollInfo.scrollFunction
					viewFrame			= {corner1=origin,corner2={x=origin.x+compoundSize.w,y=origin.y+compoundSize.h}}
					(min,oldThumb,max,viewSize)
										= if isHorizontal
											(domain.corner1.x,origin.x,domain.corner2.x,compoundSize.w)
											(domain.corner1.y,origin.y,domain.corner2.y,compoundSize.h)
					sliderState			= {sliderMin=min,sliderThumb=oldThumb,sliderMax=max-viewSize}
					newThumb			= SetBetween (scrollFun viewFrame sliderState info.csaSliderMove) min (max-viewSize)
					(_,newOSThumb,_,_)	= toOSscrollbarRange (min,newThumb,max) viewSize
					newOrigin			= if isHorizontal {origin & x=newThumb} {origin & y=newThumb}
		elementsCompoundScrollActionIO _ _ tb
			= (False,[],tb)
windowStateCompoundScrollActionIO _ _ _
	= windowdeviceFatalError "windowStateCompoundScrollActionIO" "unexpected window placeholder"


/*	windowStateControlKeyboardActionIO handles the keyboard actions of CustomControls and CompoundControls (not yet).
*/
windowStateControlKeyboardActionIO :: !ControlKeyboardActionInfo !(WindowStateHandle (PSt .l .p)) !(PSt .l .p) -> (!WindowStateHandle (PSt .l .p),PSt .l .p)
windowStateControlKeyboardActionIO info wsH=:{wshHandle=Just wlsH=:{wlsState=ls,wlsHandle=wH}} pState
	= ({wsH & wshHandle=Just {wlsH & wlsState=ls1,wlsHandle=wH1}},pState1)
where
	(wH1,(ls1,pState1))	= windowControlKeyboardActionIO info wH (ls,pState)
	
	windowControlKeyboardActionIO :: !ControlKeyboardActionInfo !(WindowHandle .ls .ps) *(.ls,.ps) -> (!WindowHandle .ls .ps,*(.ls,.ps))
	windowControlKeyboardActionIO info wH=:{whItems} ls_ps
		= ({wH & whItems=itemHs},ls_ps1)
	where
		(_,itemHs,ls_ps1)	= elementsControlKeyboardActionIO info whItems ls_ps
		
		elementsControlKeyboardActionIO :: !ControlKeyboardActionInfo ![WElementHandle .ls .ps] *(.ls,.ps) -> (!Bool,![WElementHandle .ls .ps],*(.ls,.ps))
		elementsControlKeyboardActionIO info [itemH:itemHs] ls_ps
			# (done,itemH,ls_ps)	= elementControlKeyboardActionIO info itemH ls_ps
			| done
			= (done,[itemH:itemHs],ls_ps)
			# (done,itemHs,ls_ps)	= elementsControlKeyboardActionIO info itemHs ls_ps
			= (done,[itemH:itemHs],ls_ps)
		where
			elementControlKeyboardActionIO :: !ControlKeyboardActionInfo !(WElementHandle .ls .ps) *(.ls,.ps) -> (!Bool,!WElementHandle .ls .ps,*(.ls,.ps))
			elementControlKeyboardActionIO info (WListLSHandle itemHs) ls_ps
				# (done,itemHs,ls_ps)			= elementsControlKeyboardActionIO info itemHs ls_ps
				= (done,WListLSHandle itemHs,ls_ps)
			elementControlKeyboardActionIO info (WExtendLSHandle {wExtendLS=extLS,wExtendItems=itemHs}) (ls,ps)
				# (done,itemHs,((extLS,ls),ps))	= elementsControlKeyboardActionIO info itemHs ((extLS,ls),ps)
				= (done,WExtendLSHandle {wExtendLS=extLS,wExtendItems=itemHs},(ls,ps))
			elementControlKeyboardActionIO info (WChangeLSHandle {wChangeLS=chLS,wChangeItems=itemHs}) (ls,ps)
				# (done,itemHs,(chLS,ps))		= elementsControlKeyboardActionIO info itemHs (chLS,ps)
				= (done,WChangeLSHandle {wChangeLS=chLS,wChangeItems=itemHs},(ls,ps))
			elementControlKeyboardActionIO info (WItemHandle itemH) ls_ps
				| info.ckItemNr<>itemH.wItemNr
					| itemH.wItemKind<>IsCompoundControl
					= (False,WItemHandle itemH,ls_ps)
					# (done,itemHs,ls_ps)	= elementsControlKeyboardActionIO info itemH.wItems ls_ps
					= (done,WItemHandle {itemH & wItems=itemHs},ls_ps)
				# (itemH,ls_ps)	= itemControlKeyboardActionIO info itemH ls_ps
				= (True, WItemHandle itemH,ls_ps)
			where
				itemControlKeyboardActionIO :: !ControlKeyboardActionInfo !(WItemHandle .ls .ps) *(.ls,.ps) -> (!WItemHandle .ls .ps,*(.ls,.ps))
				itemControlKeyboardActionIO {ckKeyboardState} itemH=:{wItemAtts} ls_ps
					= (itemH,f ckKeyboardState ls_ps)
				where
					(_,_,f)	= getcontrolkeyboardinfo (snd (Select iscontrolkeyboard undef wItemAtts))
		elementsControlKeyboardActionIO _ _ ls_ps
			= (False,[],ls_ps)
windowStateControlKeyboardActionIO _ _ _
	= windowdeviceFatalError "windowStateControlKeyboardActionIO" "unexpected window placeholder"


/*	windowStateControlMouseActionIO handles the mouse actions of CustomControls and CompoundControls (not yet).
*/
windowStateControlMouseActionIO :: !ControlMouseActionInfo !(WindowStateHandle (PSt .l .p)) (PSt .l .p) -> (!WindowStateHandle (PSt .l .p),PSt .l .p)
windowStateControlMouseActionIO info wsH=:{wshHandle=Just wlsH=:{wlsState=ls,wlsHandle=wH}} pState
	= ({wsH & wshHandle=Just {wlsH & wlsState=ls1,wlsHandle=wH1}},pState1)
where
	(wH1,(ls1,pState1))	= windowControlMouseActionIO info wH (ls,pState)
	
	windowControlMouseActionIO :: !ControlMouseActionInfo !(WindowHandle .ls .ps) *(.ls,.ps) -> (!WindowHandle .ls .ps,*(.ls,.ps))
	windowControlMouseActionIO info wH=:{whItems} ls_ps
		= ({wH & whItems=itemHs},ls_ps1)
	where
		(_,itemHs,ls_ps1)	= elementsControlMouseActionIO info whItems ls_ps
		
		elementsControlMouseActionIO :: !ControlMouseActionInfo ![WElementHandle .ls .ps] *(.ls,.ps) -> (!Bool,![WElementHandle .ls .ps],*(.ls,.ps))
		elementsControlMouseActionIO info [itemH:itemHs] ls_ps
			# (done,itemH,ls_ps)	= elementControlMouseActionIO info itemH ls_ps
			| done
			= (done,[itemH:itemHs],ls_ps)
			# (done,itemHs,ls_ps)	= elementsControlMouseActionIO info itemHs ls_ps
			= (done,[itemH:itemHs],ls_ps)
		where
			elementControlMouseActionIO :: !ControlMouseActionInfo !(WElementHandle .ls .ps) *(.ls,.ps) -> (!Bool,!WElementHandle .ls .ps,*(.ls,.ps))
			elementControlMouseActionIO info (WListLSHandle itemHs) ls_ps
				# (done,itemHs,ls_ps)			= elementsControlMouseActionIO info itemHs ls_ps
				= (done,WListLSHandle itemHs,ls_ps)
			elementControlMouseActionIO info (WExtendLSHandle {wExtendLS=extLS,wExtendItems=itemHs}) (ls,ps)
				# (done,itemHs,((extLS,ls),ps))	= elementsControlMouseActionIO info itemHs ((extLS,ls),ps)
				= (done,WExtendLSHandle {wExtendLS=extLS,wExtendItems=itemHs},(ls,ps))
			elementControlMouseActionIO info (WChangeLSHandle {wChangeLS=chLS,wChangeItems=itemHs}) (ls,ps)
				# (done,itemHs,(chLS,ps))		= elementsControlMouseActionIO info itemHs (chLS,ps)
				= (done,WChangeLSHandle {wChangeLS=chLS,wChangeItems=itemHs},(ls,ps))
			elementControlMouseActionIO info (WItemHandle itemH) ls_ps
				| info.cmItemNr<>itemH.wItemNr
					| itemH.wItemKind<>IsCompoundControl
					= (False,WItemHandle itemH,ls_ps)
					# (done,itemHs,ls_ps)	= elementsControlMouseActionIO info itemH.wItems ls_ps
					= (done,WItemHandle {itemH & wItems=itemHs},ls_ps)
				# (itemH,ls_ps)	= itemControlMouseActionIO info itemH ls_ps
				= (True, WItemHandle itemH,ls_ps)
			where
				itemControlMouseActionIO :: !ControlMouseActionInfo !(WItemHandle .ls .ps) *(.ls,.ps) -> (!WItemHandle .ls .ps,*(.ls,.ps))
				itemControlMouseActionIO {cmMouseState} itemH=:{wItemAtts} ls_ps
					= (itemH,f cmMouseState ls_ps)
				where
					(_,_,f)	= getcontrolmouseinfo (snd (Select iscontrolmouse undef wItemAtts))
		elementsControlMouseActionIO _ _ ls_ps
			= (False,[],ls_ps)
windowStateControlMouseActionIO _ _ _
	= windowdeviceFatalError "windowStateControlMouseActionIO" "unexpected window placeholder"


/*	windowStateControlSelectionIO handles the selection of the control.
*/
windowStateControlSelectionIO :: !ControlSelectInfo !(WindowStateHandle (PSt .l .p)) (PSt .l .p) -> (!WindowStateHandle (PSt .l .p),PSt .l .p)
windowStateControlSelectionIO info wsH=:{wshHandle=Just wlsH=:{wlsState=ls,wlsHandle=wH}} pState
	= ({wsH & wshHandle=Just {wlsH & wlsState=ls1,wlsHandle=wH1}},pState1)
where
	(wH1,(ls1,pState1))	= windowControlSelectionIO info wH (ls,pState)
	
	windowControlSelectionIO :: !ControlSelectInfo !(WindowHandle .ls .ps) *(.ls,.ps) -> (!WindowHandle .ls .ps, *(.ls,.ps))
	windowControlSelectionIO info wH=:{whItems} ls_ps
		# (_,itemHs,ls_ps)	= elementsControlSelectionIO info whItems ls_ps
		= ({wH & whItems=itemHs},ls_ps)
	where
		elementsControlSelectionIO :: !ControlSelectInfo ![WElementHandle .ls .ps] *(.ls,.ps) -> (!Bool,![WElementHandle .ls .ps],*(.ls,.ps))
		elementsControlSelectionIO info [itemH:itemHs] ls_ps
			# (done,itemH,ls_ps)	= elementControlSelectionIO info itemH ls_ps
			| done
			= (done,[itemH:itemHs],ls_ps)
			# (done,itemHs,ls_ps)	= elementsControlSelectionIO info itemHs ls_ps
			= (done,[itemH:itemHs],ls_ps)
		where
			elementControlSelectionIO :: !ControlSelectInfo !(WElementHandle .ls .ps) *(.ls,.ps) -> (!Bool,!WElementHandle .ls .ps,*(.ls,.ps))
			elementControlSelectionIO info (WListLSHandle itemHs) ls_ps
				# (done,itemHs,ls_ps)			= elementsControlSelectionIO info itemHs ls_ps
				= (done,WListLSHandle itemHs,ls_ps)
			elementControlSelectionIO info (WExtendLSHandle {wExtendLS=extLS,wExtendItems=itemHs}) (ls,ps)
				# (done,itemHs,((extLS,ls),ps))	= elementsControlSelectionIO info itemHs ((extLS,ls),ps)
				= (done,WExtendLSHandle {wExtendLS=extLS,wExtendItems=itemHs},(ls,ps))
			elementControlSelectionIO info (WChangeLSHandle {wChangeLS=chLS,wChangeItems=itemHs}) (ls,ps)
				# (done,itemHs,(chLS,ps))		= elementsControlSelectionIO info itemHs (chLS,ps)
				= (done,WChangeLSHandle {wChangeLS=chLS,wChangeItems=itemHs},(ls,ps))
			elementControlSelectionIO info (WItemHandle itemH) ls_ps
				| info.csItemNr<>itemH.wItemNr
					| itemH.wItemKind<>IsCompoundControl
					= (False,WItemHandle itemH,ls_ps)
					# (done,itemHs,ls_ps)	= elementsControlSelectionIO info itemH.wItems ls_ps
					= (done,WItemHandle {itemH & wItems=itemHs},ls_ps)
				# (itemH,ls_ps)	= itemControlSelectionIO info itemH ls_ps
				= (True,WItemHandle itemH,ls_ps)
			where
				itemControlSelectionIO :: !ControlSelectInfo !(WItemHandle .ls .ps) *(.ls,.ps) -> (!WItemHandle .ls .ps,*(.ls,.ps))
				itemControlSelectionIO info itemH=:{wItemKind=IsRadioControl} ls_ps
					# radioInfo		= RadioInfo {radioInfo & radioIndex=index}
					  itemH			= {itemH & wItemInfo=radioInfo}
					= (itemH,f ls_ps)
				where
					itemPtr			= info.csItemPtr
					radioInfo		= getWItemRadioInfo itemH.wItemInfo
					error			= windowdeviceFatalError "windowIO _ (ControlSelection _) _" "RadioControlItem could not be found"
					(index,radio)	= SelectedAtIndex (\{radioItemPtr}->radioItemPtr==itemPtr) error radioInfo.radioItems
					f				= snd radio.radioItem
				itemControlSelectionIO info itemH=:{wItemKind=IsCheckControl} ls_ps
					# checkInfo		= CheckInfo {checkInfo & checkItems=checks}
					  itemH			= {itemH & wItemInfo=checkInfo}
					= (itemH,f ls_ps)
				where
					itemPtr			= info.csItemPtr
					checkInfo		= getWItemCheckInfo itemH.wItemInfo
					error			= windowdeviceFatalError "windowIO _ (ControlSelection _) _" "CheckControlItem could not be found"
					(_,f,checks)	= Access (isCheckItem itemPtr) error checkInfo.checkItems
					
					isCheckItem :: !OSWindowPtr !(CheckItemInfo (.ls,.ps)) -> ((!Bool,!IdFun (.ls,.ps)),!CheckItemInfo (.ls,.ps))
					isCheckItem itemPtr check=:{checkItemPtr,checkItem=(title,mark,f)}
						= ((checkItemPtr==itemPtr,f),{check & checkItem=(title,~mark,f)})
				itemControlSelectionIO info itemH=:{wItemKind=IsPopUpControl} ls_ps
					# popUpInfo		= PopUpInfo {popUpInfo & popUpInfoIndex=index}
					  itemH			= {itemH & wItemInfo=popUpInfo}
					= (itemH,f ls_ps)
				where
					popUpInfo		= getWItemPopUpInfo itemH.wItemInfo
					index			= info.csMoreData
					(_,f)			= popUpInfo.popUpInfoItems!!(index-1)
				itemControlSelectionIO info itemH=:{wItemKind} ls_ps
					| wItemKind==IsButtonControl || wItemKind==IsCustomButtonControl
						| hasAtt
						= (itemH,f ls_ps)
						= (itemH,  ls_ps)
					= (itemH,ls_ps)
				where
					atts			= itemH.wItemAtts
					(hasAtt,fAtt)	= Select (\att->iscontrolfunction att || iscontrolmodsfunction att) undef atts
					f				= case fAtt of
										(ControlFunction     f)	-> f
										(ControlModsFunction f)	-> f info.csModifiers
		elementsControlSelectionIO _ _ ls_ps
			= (False,[],ls_ps)
windowStateControlSelectionIO _ _ _
	= windowdeviceFatalError "windowStateControlSelectionIO" "unexpected window placeholder"


/*	windowStateControlSliderActionIO handles the slider of windows/dialogs.
*/
windowStateControlSliderActionIO :: !ControlSliderInfo !(WindowStateHandle (PSt .l .p)) (PSt .l .p) -> (!WindowStateHandle (PSt .l .p),PSt .l .p)
windowStateControlSliderActionIO info wsH=:{wshHandle=Just wlsH=:{wlsState=ls,wlsHandle=wH}} pState
	= ({wsH & wshHandle=Just {wlsH & wlsState=ls1,wlsHandle=wH1}},pState1)
where
	(wH1,(ls1,pState1))	= windowControlSliderAction info wH (ls,pState)
	
	windowControlSliderAction :: !ControlSliderInfo !(WindowHandle .ls .ps) (.ls,.ps) -> (!WindowHandle .ls .ps,(.ls,.ps))
	windowControlSliderAction info wH=:{whItems} ls_ps
		= ({wH & whItems=itemHs},ls_ps1)
	where
		(_,itemHs,ls_ps1)	= elementsControlSliderActionIO info whItems ls_ps
		
		elementsControlSliderActionIO :: !ControlSliderInfo ![WElementHandle .ls .ps] (.ls,.ps) -> (!Bool,![WElementHandle .ls .ps],(.ls,.ps))
		elementsControlSliderActionIO info [itemH:itemHs] ls_ps
			# (done,itemH,ls_ps)	= elementControlSliderActionIO info itemH ls_ps
			| done
			= (done,[itemH:itemHs],ls_ps)
			# (done,itemHs,ls_ps)	= elementsControlSliderActionIO info itemHs ls_ps
			= (done,[itemH:itemHs],ls_ps)
		where
			elementControlSliderActionIO :: !ControlSliderInfo !(WElementHandle .ls .ps) (.ls,.ps) -> (!Bool,!WElementHandle .ls .ps,(.ls,.ps))
			elementControlSliderActionIO info (WListLSHandle itemHs) ls_ps
				# (done,itemHs,ls_ps)			= elementsControlSliderActionIO info itemHs ls_ps
				= (done,WListLSHandle itemHs,ls_ps)
			elementControlSliderActionIO info (WExtendLSHandle {wExtendLS=extLS,wExtendItems=itemHs}) (ls,ps)
				# (done,itemHs,((extLS,ls),ps))	= elementsControlSliderActionIO info itemHs ((extLS,ls),ps)
				= (done,WExtendLSHandle {wExtendLS=extLS,wExtendItems=itemHs},(ls,ps))
			elementControlSliderActionIO info (WChangeLSHandle {wChangeLS=chLS,wChangeItems=itemHs}) (ls,ps)
				# (done,itemHs,(chLS,ps))		= elementsControlSliderActionIO info itemHs (chLS,ps)
				= (done,WChangeLSHandle {wChangeLS=chLS,wChangeItems=itemHs},(ls,ps))
			elementControlSliderActionIO info (WItemHandle itemH) ls_ps
				| info.cslItemNr<>itemH.wItemNr
					| itemH.wItemKind<>IsCompoundControl
					= (False,WItemHandle itemH,ls_ps)
					# (done,itemHs,ls_ps)	= elementsControlSliderActionIO info itemH.wItems ls_ps
					= (done,WItemHandle {itemH & wItems=itemHs},ls_ps)
				# (itemH,ls_ps)	= itemControlSliderActionIO info itemH ls_ps
				= (True,WItemHandle itemH,ls_ps)
			where
				itemControlSliderActionIO :: !ControlSliderInfo !(WItemHandle .ls .ps) (.ls,.ps) -> (!WItemHandle .ls .ps,(.ls,.ps))
				itemControlSliderActionIO info itemH=:{wItemKind=IsSliderControl} ls_ps
					= (itemH,f info.cslSliderMove ls_ps)
				where
					f	= (getWItemSliderInfo itemH.wItemInfo).sliderInfoAction
				itemControlSliderActionIO _ itemH ls_ps
					= (itemH,ls_ps)
		elementsControlSliderActionIO _ _ ls_ps
			= (False,[],ls_ps)
windowStateControlSliderActionIO _ _ _
	= windowdeviceFatalError "windowStateControlSliderActionIO" "unexpected window placeholder"


/*	windowStateActivationIO handles the activation of the window/dialog.
*/
windowStateActivationIO :: !(WindowStateHandle (PSt .l .p)) (PSt .l .p) -> (!WindowStateHandle (PSt .l .p),PSt .l .p)
windowStateActivationIO wsH=:{wshHandle=Just wlsH=:{wlsState=ls,wlsHandle=wH}} pState
	= ({wsH & wshHandle=Just {wlsH & wlsState=ls1,wlsHandle=wH1}},pState1)
where
	(wH1,(ls1,pState1))	= windowActivationIO wH (ls,pState)
	
	windowActivationIO :: !(WindowHandle .ls .ps) *(.ls,.ps) -> (!WindowHandle .ls .ps,*(.ls,.ps))
	windowActivationIO wH=:{whAtts} ls_ps
		| hasAtt
		= (wH,f ls_ps)
		= (wH,  ls_ps)
	where
		(hasAtt,activateAtt)= Select iswindowactivate undef whAtts
		f					= getwindowactivatefunction activateAtt
windowStateActivationIO _ _
	= windowdeviceFatalError "windowStateActivationIO" "unexpected window placeholder"


/*	windowStateDeactivationIO handles the deactivation of the window/dialog.
*/
windowStateDeactivationIO :: !(WindowStateHandle (PSt .l .p)) (PSt .l .p) -> (!WindowStateHandle (PSt .l .p),PSt .l .p)
windowStateDeactivationIO wsH=:{wshHandle=Just wlsH=:{wlsState=ls,wlsHandle=wH}} pState
	= ({wsH & wshHandle=Just {wlsH & wlsState=ls1,wlsHandle=wH1}},pState1)
where
	(wH1,(ls1,pState1))	= windowDeactivationIO wH (ls,pState)
	
	windowDeactivationIO :: !(WindowHandle .ls .ps) *(.ls,.ps) -> (!WindowHandle .ls .ps,*(.ls,.ps))
	windowDeactivationIO wH=:{whAtts} ls_ps
		| hasAtt
		= (wH,f ls_ps)
		= (wH,  ls_ps)
	where
		(hasAtt,deactivateAtt)	= Select iswindowdeactivate undef whAtts
		f						= getwindowdeactivatefunction deactivateAtt
windowStateDeactivationIO _ _
	= windowdeviceFatalError "windowStateDeactivationIO" "unexpected window placeholder"


/*	windowStateWindowKeyboardActionIO handles the keyboard for the window.
*/
windowStateWindowKeyboardActionIO :: !WindowKeyboardActionInfo !(WindowStateHandle (PSt .l .p)) (PSt .l .p) -> (!WindowStateHandle (PSt .l .p),PSt .l .p)
windowStateWindowKeyboardActionIO info wsH=:{wshHandle=Just wlsH=:{wlsState=ls,wlsHandle=wH}} pState
	= ({wsH & wshHandle=Just {wlsH & wlsState=ls1,wlsHandle=wH1}},pState1)
where
	(wH1,(ls1,pState1))	= windowKeyboardActionIO info.wkKeyboardState wH (ls,pState)
	
	windowKeyboardActionIO :: !KeyboardState !(WindowHandle .ls .ps) *(.ls,.ps) -> (!WindowHandle .ls .ps,*(.ls,.ps))
	windowKeyboardActionIO key wH=:{whAtts} ls_ps
		= (wH,f key ls_ps)
	where
		(_,_,f) = getwindowkeyboardinfo (snd (Select iswindowkeyboard undef whAtts))
windowStateWindowKeyboardActionIO _ _ _
	= windowdeviceFatalError "windowStateWindowKeyboardActionIO" "unexpected window placeholder"


/*	windowStateWindowMouseActionIO handles the mouse for the window.
*/
windowStateWindowMouseActionIO :: !WindowMouseActionInfo !(WindowStateHandle (PSt .l .p)) (PSt .l .p) -> (!WindowStateHandle (PSt .l .p),PSt .l .p)
windowStateWindowMouseActionIO info wsH=:{wshHandle=Just wlsH=:{wlsState=ls,wlsHandle=wH}} pState
	= ({wsH & wshHandle=Just {wlsH & wlsState=ls1,wlsHandle=wH1}},pState1)
where
	(wH1,(ls1,pState1))	= windowMouseActionIO info.wmMouseState wH (ls,pState)
	
	windowMouseActionIO :: !MouseState !(WindowHandle .ls .ps) *(.ls,.ps) -> (!WindowHandle .ls .ps,*(.ls,.ps))
	windowMouseActionIO mouse wH=:{whAtts} ls_ps
		= (wH,f mouse ls_ps)
	where
		(_,_,f) = getwindowmouseinfo (snd (Select iswindowmouse undef whAtts))
windowStateWindowMouseActionIO _ _ _
	= windowdeviceFatalError "windowStateWindowMouseActionIO" "unexpected window placeholder"


/*	windowStateRequestCloseIO handles the request to close the window/dialog.
*/
windowStateRequestCloseIO :: !(WindowStateHandle (PSt .l .p)) (PSt .l .p) -> (!WindowStateHandle (PSt .l .p),PSt .l .p)
windowStateRequestCloseIO wsH=:{wshHandle=Just wlsH=:{wlsState=ls,wlsHandle=wH}} pState
	= ({wsH & wshHandle=Just {wlsH & wlsState=ls1,wlsHandle=wH1}},pState1)
where
	(wH1,(ls1,pState1))	= windowRequestCloseIO wH (ls,pState)
	
	windowRequestCloseIO :: !(WindowHandle .ls .ps) *(.ls,.ps) -> (!WindowHandle .ls .ps,*(.ls,.ps))
	windowRequestCloseIO wH=:{whAtts} ls_ps
		| hasAtt
		= (wH,f ls_ps)
		= (wH,  ls_ps)
	where
		(hasAtt,closeAtt)	= Select iswindowclose undef whAtts
		f					= getwindowclosefunction closeAtt
windowStateRequestCloseIO _ _
	= windowdeviceFatalError "windowStateRequestCloseIO" "unexpected window placeholder"


/*	windowStateScrollActionIO handles the mouse action of window scrollbars.
*/
windowStateScrollActionIO :: !WindowScrollActionInfo !(WindowStateHandle .ps) !*OSToolbox -> (!WindowStateHandle .ps,!*OSToolbox)
windowStateScrollActionIO info wsH=:{wshHandle=Just wlsH=:{wlsHandle=wH}} tb
	# (wMetrics,tb)	= OSDefaultWindowMetrics tb
	# (wH,tb)		= windowScrollActionIO wMetrics info wH tb
	= ({wsH & wshHandle=Just {wlsH & wlsHandle=wH}},tb)
where
	windowScrollActionIO :: !OSWindowMetrics !WindowScrollActionInfo !(WindowHandle .ls .ps) !*OSToolbox -> (!WindowHandle .ls .ps,!*OSToolbox)
	windowScrollActionIO wMetrics info=:{wsaWIDS={wPtr}} wH=:{whWindowInfo,whItems,whSize={w,h}} tb
		| newThumb==oldThumb
		= (wH,tb)
		# (_,newOSThumb,_,_)	= toOSscrollbarRange (min,newThumb,max) viewSize
		  newOrigin				= if isHorizontal {origin & x=newThumb} {origin & y=newThumb}
		# tb					= OSsetWindowSliderThumb wPtr isHorizontal newOSThumb True tb
		# (itemHs,tb)			= movecontrolspos (toVector (origin-newOrigin)) info.wsaWIDS.wPtr zero whItems tb
		# tb					= OSinvalidateWindow wPtr tb
		  wH					= {	wH & whWindowInfo	= Just {windowInfo & windowOrigin=newOrigin}
				  					   , whItems		= itemHs
				  				  }
		  wH					= invalidateWindowClipState wH
		= (wH,tb)
	where
		windowInfo				= fromJust whWindowInfo
		origin					= windowInfo.windowOrigin
		domain					= windowInfo.windowDomain
		hasHScroll				= isJust windowInfo.windowHScroll
		hasVScroll				= isJust windowInfo.windowVScroll
		isHorizontal			= info.wsaDirection==Horizontal
		(visHScroll,visVScroll)	= OSscrollbarsAreVisible wMetrics (RectangleToRect domain) (w,h) (hasHScroll,hasVScroll)
		(_,_,w`,h`)				= getWindowContentRect wMetrics visHScroll visVScroll (0,0,w,h)
		(min,oldThumb,max,viewSize)
								= if isHorizontal
									(domain.corner1.x,origin.x,domain.corner2.x,w`)
									(domain.corner1.y,origin.y,domain.corner2.y,h`)
		sliderState				= {sliderMin=min,sliderThumb=oldThumb,sliderMax=max-viewSize}
		viewFrame				= {corner1=origin,corner2={x=origin.x+w`,y=origin.y+h`}}
		scrollInfo				= fromJust (if isHorizontal windowInfo.windowHScroll windowInfo.windowVScroll)
		scrollFun				= scrollInfo.scrollFunction
		newThumb				= SetBetween (scrollFun viewFrame sliderState info.wsaSliderMove) min (max-viewSize)
windowStateScrollActionIO _ _ _
	= windowdeviceFatalError "windowStateScrollActionIO" "unexpected window placeholder"


/*	windowStateSizeAction handles resizing a window and its controls.
*/
windowStateSizeAction :: !WindowSizeActionInfo !(WindowStateHandle .ps) !*OSToolbox -> (!WindowStateHandle .ps,!*OSToolbox)
windowStateSizeAction info=:{wsWIDS={wPtr},wsSize} wsH=:{wshHandle=Just wlsH=:{wlsHandle=wH}} tb
	# (wMetrics,tb)				= OSDefaultWindowMetrics tb
	  (visHScroll,visVScroll)	= OSscrollbarsAreVisible wMetrics domainRect (oldW,oldH) (hasHScroll,hasVScroll)
	  (_,_,oldW`,oldH`)			= getWindowContentRect wMetrics visHScroll visVScroll (0,0, oldW,oldH)
	  (visHScroll,visVScroll)	= OSscrollbarsAreVisible wMetrics domainRect (newW,newH) (hasHScroll,hasVScroll)
	  (_,_,newW`,newH`)			= getWindowContentRect wMetrics visHScroll visVScroll (0,0, newW,newH)
	  newOrigin					= newOrigin origin domainRect (newW`,newH`)
	  newWindowInfo				= Just {windowInfo & windowOrigin=newOrigin}
	  resizedAtt				= WindowSize {w=newW`,h=newH`}
	  (replaced,atts)			= Replace iswindowsize resizedAtt wH.whAtts
	  resizedAtts				= if replaced atts [resizedAtt:atts]
	  wH						= {wH & whSize=wsSize,whWindowInfo=newWindowInfo,whAtts=resizedAtts}
	  wH						= invalidateWindowClipState wH
	  wsH						= {wsH & wshHandle=Just {wlsH & wlsHandle=wH}}
	  hThumbSize				= if visVScroll (newW-wMetrics.osmVSliderWidth +1) (newW+1)
	  vThumbSize				= if visHScroll (newH-wMetrics.osmHSliderHeight+1) (newH+1)
	# tb						= setWindowScrollThumbValues hasHScroll wPtr True  hThumbSize origin.x newOrigin.x tb
	# tb						= setWindowScrollThumbValues hasVScroll wPtr False vThumbSize origin.y newOrigin.y tb
	  oldViewFrame				= {corner1=origin,   corner2={x=origin.x   +oldW`,y=origin.y   +oldH`}}
	  newViewFrame				= {corner1=newOrigin,corner2={x=newOrigin.x+newW`,y=newOrigin.y+newH`}}
	# (wsH,tb)					= resizeControls wMetrics oldViewFrame newViewFrame wsH tb
	= (wsH,tb)
where
	oldSize						= wH.whSize
	(oldW,oldH)					= toTuple oldSize
	(newW,newH)					= toTuple wsSize
	windowInfo					= fromJust wH.whWindowInfo
	domain						= windowInfo.windowDomain
	origin						= windowInfo.windowOrigin
	hasHScroll					= isJust windowInfo.windowHScroll
	hasVScroll					= isJust windowInfo.windowVScroll
	domainRect					= RectangleToRect domain
	
	newOrigin :: !Point !Rect !(!Int,!Int) -> Point
	newOrigin {x,y} (xMin,yMin,xMax,yMax) (w,h)
		= {x=x`,y=y`}
	where
		x`	= if (x+w>xMax) (max (xMax-w) xMin) x
		y`	= if (y+h>yMax) (max (yMax-h) yMin) y
	
	setWindowScrollThumbValues :: !Bool OSWindowPtr Bool Int Int Int !*OSToolbox -> *OSToolbox
	setWindowScrollThumbValues hasScroll wPtr isHorizontal size old new tb
		| not hasScroll
		= tb
		# tb	= OSsetWindowSliderThumbSize wPtr isHorizontal size (old==new) tb
		| old==new
		= tb
		= OSsetWindowSliderThumb wPtr isHorizontal new True tb
windowStateSizeAction _ _ _
	= windowdeviceFatalError "windowIO _ (WindowSizeAction _) _" "unexpected placeholder argument"


//	Auxiliary function (move to commondef??):
SelectedAtIndex :: (Cond x) x ![x] -> (!Index, x)		// if index==0 then not found; item was found at index
SelectedAtIndex cond dummy xs
	= (if found i 0,x)
where
	(found,i,x) = selected cond dummy xs 1
	
	selected :: (Cond x) x ![x] !Int -> (!Bool,!Int,x)
	selected cond dummy [x:xs] i
		| cond x
		= (True,i,x)
		= selected cond dummy xs (i+1)
	selected _ dummy _ i
		= (False,i,dummy)
